@extends('layouts.app')

@section('title', 'Users')

@section('content')
<div class="container">
    <div class="users-header">
        <h1 class="h1">Users</h1>
        <p class="text-secondary">Browse and search for community members</p>
    </div>

    <div class="user-search">
        <form action="{{ route('users.index') }}" method="GET" class="search-form">
            <input 
                type="text" 
                name="search" 
                class="search-input" 
                placeholder="Search by name or Steam" 
                value="{{ $search ?? '' }}"
            >
            <button type="submit" class="search-button">
                <i class="fas fa-search"></i> Search
            </button>
        </form>
    </div>

    <div class="user-filters">
        <h3 class="filter-title">Filter by Role</h3>
        <form action="{{ route('users.index') }}" method="GET" id="role-filter-form">
            @if($search)
            <input type="hidden" name="search" value="{{ $search }}">
            @endif
            
            <div class="role-options">
                <label class="role-option">
                    <input 
                        type="radio" 
                        name="role" 
                        value="" 
                        {{ !$role ? 'checked' : '' }} 
                        onchange="document.getElementById('role-filter-form').submit()"
                    >
                    <span class="role-label">All Roles</span>
                </label>
                
                @foreach($roles as $roleOption)
                <label class="role-option">
                    <input 
                        type="radio" 
                        name="role" 
                        value="{{ $roleOption }}" 
                        {{ $role == $roleOption ? 'checked' : '' }}
                        onchange="document.getElementById('role-filter-form').submit()"
                    >
                    <span class="role-label">{{ ucfirst($roleOption) }}</span>
                </label>
                @endforeach
            </div>
        </form>
    </div>

    <div class="users-list">
        @if($users->count() > 0)
            @foreach($users as $user)
            <div class="user-card {{ $user->banner ? 'has-banner' : '' }}">
                @if($user->banner)
                    <img src="{{ Storage::url('user_banners/' . $user->banner) }}" alt="" class="user-banner">
                @endif
                
                <div class="user-avatar">
                    <img src="{{ $user->avatar }}" alt="{{ $user->name }}">
                </div>
                
                <div class="user-info">
                    <div class="user-header">
                        <h3 class="user-name">{{ $user->name }}</h3>
                        @if($user->getRoleNames()->count() > 0)
                        <div class="user-role-tag">
                            <span class="role-badge">{{ ucfirst($user->getRoleNames()->first()) }}</span>
                        </div>
                        @endif
                    </div>
                    
                    <div class="user-meta">
                        @if($user->steamid)
                        <span class="steam-id">
                            <i class="fab fa-steam"></i> 
                            {{ $user->steamid }}
                        </span>
                        @endif
                        <span class="join-date">
                            <i class="fas fa-calendar"></i> Joined {{ $user->created_at->format('M d, Y') }}
                        </span>
                    </div>
                </div>
                
                <div class="user-actions">
                    <a href="{{ route('users.show', $user->slug) }}" class="btn-view">
                        <i class="fas fa-eye"></i> View
                    </a>
                </div>
            </div>
            @endforeach
            
            <div class="user-pagination">
                {{ $users->links() }}
            </div>
        @else
            <div class="users-empty-state">
                <div class="empty-icon">
                    <i class="fas fa-users-slash"></i>
                </div>
                <h3 class="empty-text">No users found</h3>
                <p class="text-secondary mb-md">
                    @if($search || $role)
                        Try adjusting your search or filter criteria
                    @else
                        There are no users registered yet
                    @endif
                </p>
                
                @if($search || $role)
                <a href="{{ route('users.index') }}" class="btn-add-user">
                    <i class="fas fa-sync"></i> Reset Filters
                </a>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection